<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // 'build_type'     => $buildType,
        // 'city'           => $city,
        // 'region'         => $region,
        // 'deal_type'      => $request->deal_type,
        // 'room_numbers'   => $request->room_numbers,
        // 'area_in_metres' => $request->area_in_metres,
        // 'price'          => number_format($request->price, 0, '.', ','),
        // 'payment_type'   => $request->payment_type,
        // 'name'           => $request->name,
        // 'phone'          => $request->phone,
        // 'call_type'      => $request->call_type,

        Schema::create('requests', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('phone');
            $table->text('message')->nullable();
            $table->string('call_type')->nullable();
            $table->string('build_type')->nullable();
            $table->string('city')->nullable();
            $table->string('region')->nullable();
            $table->string('deal_type')->nullable();
            $table->string('room_numbers')->nullable();
            $table->string('area_in_metres')->nullable();
            $table->string('price')->nullable();
            $table->string('payment_type')->nullable();
            $table->enum('type', ['real_estate', 'ads'])->default('real_estate')->comment('Request Types');
            $table->enum('read', ['1', '0'])->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('requests');
    }
};
